﻿Public Class PWMControl

    Public Property X1() As Single
        Get
            Return x1Value
        End Get
        Set(ByVal value As Single)
            If value < 0 Then value = 0
            x1Value = value
            Me.Invalidate()
        End Set
    End Property
    Private x1Value As Single

    Public Property X2() As Single
        Get
            Return x2Value
        End Get
        Set(ByVal value As Single)
            If value > 1 Then value = 1
            x2Value = value
        End Set
    End Property
    Private x2Value As Single

    Public Property ADCpoint1() As Single
        Get
            Return adcPoint1Value
        End Get
        Set(ByVal value As Single)
            adcPoint1Value = value
        End Set
    End Property
    Private adcPoint1Value As Single

    Public Property ADCpoint2() As Single
        Get
            Return adcPoint2Value
        End Get
        Set(ByVal value As Single)
            adcPoint2Value = value
        End Set
    End Property
    Private adcPoint2Value As Single

    Protected Overrides Sub OnPaintBackground(ByVal e As System.Windows.Forms.PaintEventArgs)
        ' MyBase.OnPaintBackground(e)
    End Sub


    Private edgePenEnabled As New Pen(Color.Black, 1)
    Private edgePenDisabled As New Pen(Color.LightGray, 1)
    
    Protected Overrides Sub OnPaint(ByVal e As System.Windows.Forms.PaintEventArgs)
        MyBase.OnPaint(e)

        Dim xWidth As Integer = (x2Value - x1Value) * Me.Width
        Dim xStart As Integer = x1Value * Me.Width

        Dim edgePen As Pen
        If Me.Enabled Then
            edgePen = edgePenEnabled
        Else
            edgePen = edgePenDisabled
        End If

        ' Draw background
        e.Graphics.FillRectangle(Brushes.White, 0, 0, xStart, Me.Height)
        e.Graphics.FillRectangle(Brushes.White, xStart + xWidth, 0, Me.Width - xStart - xWidth, Me.Height)

        If Me.Enabled Then
            ' Draw rectangle
            e.Graphics.FillRectangle(Brushes.Black, xStart, 0, xWidth, Me.Height)

            ' Draw line 
            e.Graphics.DrawLine(Pens.Red, adcPoint1Value * Width, 0, adcPoint1Value * Width, Me.Height)
            e.Graphics.DrawLine(Pens.Purple, adcPoint2Value * Width, 0, adcPoint2Value * Width, Me.Height)
        End If

        e.Graphics.DrawRectangle(edgePen, 0, 0, Me.Width - 1, Me.Height - 1)
    End Sub

End Class
